10 CLS
15 REM Corrected error in wavelength conversion, Mar 1997
20 PRINT "GAMMA MATCH DESIGN"
30 PRINT "After R. Nelson, WB0IKN, Ham Radio, Jan 1985"
40 PRINT
50 DEF FNCSH (X) = LOG(X + SQR(X * X - 1))
60 PI = 3.14159
70 INPUT "Is this design for a <M>onopole or <D>ipole (M/D)"; DM$
80 IF DM$ = "d" THEN DM$ = "D"
90 IF DM$ = "m" THEN DM$ = "M"
100 IF DM$ = "D" OR DM$ = "M" THEN GOTO 120
110 PRINT CHR$(7): GOTO 70
120 INPUT "Frequency, MHz"; F
130 INPUT "Feed point resistance, ohms"; RA
140 INPUT "Feed point reactance, ohms"; XA
150 IF DM$ = "D" THEN RA = RA / 2
160 IF DM$ = "D" THEN XA = XA / 2
170 INPUT "Feed line impedance, ohms"; RO
180 PRINT : INPUT "Driven element diameter, inches"; DE
190 INPUT "Gamma rod diameter, inches"; DR
200 INPUT "Gamma rod spacing, inches"; S
210 HZ = (1 + ((FNCSH((4 * S * S - DE * DE + DR * DR) / (4 * S * DR))) / (FNCSH((4 * S * S + DE * DE - DR * DR) / (4 * S * DE))))) ^ 2
220 ZO = 60 * FNCSH((4 * S * S - DE * DE - DR * DR) / (2 * DE * DR))
230 T = HZ / ZO
240 A = ((RO * XA) / (HZ * RA - RO))
250 B = (RO * (RA ^ 2 + XA ^ 2)) / (HZ * RA - RO)
260 Q = A + SQR(A * A + B)
270 XS = HZ * ((RO * XA + SQR((RO * XA) ^ 2 + RO * (HZ * RA - RO) * (RA ^ 2 + XA ^ 2))) / (HZ * RA - RO))
280 LDRA = ATN(Q * T)
290 LDR = LDRA * 180 / PI
300 E = (RO / RA) * ((RA ^ 2 + XA ^ 2) / Q)
310 G = (RO / RA) * XA
320 CR = 1000000! / (2 * PI * (E + G) * F)
330 CLS
340 IF DM$ = "D" THEN RA = RA * 2
350 IF DM$ = "D" THEN XA = XA * 2
360 PRINT
370 IF DM$ = "D" THEN PRINT "DIPOLE ANTENNA" ELSE PRINT "MONOPOLE ANTENNA"
380 PRINT
390 PRINT "Frequency, MHz: "; F
400 PRINT "Driven element diam: "; DE
410 PRINT "Gamma rod diam: "; DR
420 PRINT "Gamma rod spacing: "; S
430 PRINT "Feed point resistance: "; RA
440 PRINT "Feed point reactance: "; XA
450 PRINT "Feed line impedance: "; RO
460 PRINT
470 PRINT "Gamma length (degrees): "; LDR
480 FT = (984 / F) * (LDR / 360): PRINT "Gamma length (feet): "; FT
490 IN = FT * 12: PRINT "Gamma length (inches): "; IN
500 PRINT "Gamma capacitor (pF): "; CR
510 PRINT : INPUT "Do another (Y/N)"; T$
520 IF T$ = "y" OR T$ = "Y" THEN GOTO 10 ELSE SYSTEM
