unit Connecting;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, SendThread, DevicesFrame, VCLUtils, RUtilites ;

const
  cStr1= 'Don`t detect AltProg';
  cStr2= 'Command error :';

type
  TfrmConnecting = class(TForm)
    BitBtn1: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Bevel1: TBevel;
    Timer: TTimer;
    lbAttempt: TLabel;
    lbTimer: TLabel;
    cbShowMsg: TCheckBox;
    procedure TimerTimer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public


    FfrmDevice:TfrmDevice;
    FMsg:String;
    FMsgDisable:boolean;
    procedure AttemptInc;
    procedure InitPromer;

    procedure Tr_InitPromer;
    procedure ThreadDoneErr(var AMessage : TMessage); message WM_ThreadDoneErrMsg;
    procedure ThreadDoneOk(var AMessage : TMessage); message WM_ThreadDoneOkMsg;

  end;

var
  frmConnecting: TfrmConnecting;

implementation


{$R *.DFM}

procedure TfrmConnecting.TimerTimer(Sender: TObject);
var T:real;
begin
  T:=StrToFloat(lbTimer.caption);
  T:=T+Timer.Interval/1000;
  lbTimer.Caption:=Format('%5.1f',[T]);
end;

procedure TfrmConnecting.AttemptInc;
var T:real;
begin
  T:=StrToFloat(lbAttempt.caption);
  T:=T+1;
  lbAttempt.Caption:=Format('%5.0f',[T]);
end;


procedure TfrmConnecting.InitPromer;
begin
  with FfrmDevice do
  begin
    CheckSendThread;
    FMsgDisable:=false;
    FSendThread.OnExecuteProcess:=Self.Tr_InitPromer;
    FSendThread.Resume;
  end;
  AttemptInc;
end;


procedure TfrmConnecting.FormShow(Sender: TObject);
begin
  InitPromer
end;

procedure TfrmConnecting.ThreadDoneErr(var AMessage: TMessage);
begin
  if not FMsgDisable then
  begin
    if cbShowMsg.Checked then MsgBox('Error!',FMsg,mb_OK);
    InitPromer
  end;
end;

procedure TfrmConnecting.ThreadDoneOk(var AMessage: TMessage);
begin
  if not FMsgDisable then
  begin
    if cbShowMsg.Checked then MsgBox('Answer',FMsg,mb_OK);
    ModalResult:=mrOk;
  end;
end;

procedure TfrmConnecting.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  with FfrmDevice do
    if FSendThread<>Nil then
    begin
      FMsgDisable:=True;
      FSendThread.FEvent.SetEvent;
      repeat until FSendThread=nil;
    end;
  Action:=caFree;
end;

procedure TfrmConnecting.Tr_InitPromer;
var str,str1:string;

begin
  try
  with FfrmDevice.FSendThread do
  begin
    if not CommPort.Enabled then
      CommPort.Open;
    try
      PurgePort;
      TimeOuts(100,1,100,1,100,1);
      SetEventChar('>');
      WriteStrToComm(^C);
      ReadStrUntilChar(str);
      if Pos('AltProg',str)=0 then
        Raise Exception.Create(cStr1);
      FMsg:=str;

      str:=FfrmDevice.ChipClassID+Chr($0d);
      WriteStrToComm(str);
      ReadStrUntilChar(str1);
      if Pos(str,str1)=0 then
        Raise Exception.CreateFmt(cStr2+' %s',[str]);
      FfrmDevice.ChipClassInitialised:=true;
      PostMessage(Self.Handle,wm_ThreadDoneOkMsg,0,0);

    finally
      CommPort.Close;
    end;
  end;
  except
    on E: Exception do
    begin
      FMsg:=E.Message;
      PostMessage(Self.Handle,wm_ThreadDoneErrMsg,0,0);
    end
  end
end;





end.
