unit CreateMenu;


interface
uses Forms,DevicesFrame,Menus,Classes,SysUtils,inifiles,stdctrls,Controls,StrUtils;

type
  TfrmDeviceClass = class of TfrmDevice;

  TDevMenuRecord = record
    Key:string;
    FrameConstructor: TfrmDeviceClass;
  end;

procedure BuildDevMenu();
procedure StartConstructor(ChipName:string);
procedure InsertToChipMenu(SectName:String);
{
procedure ShowMemoForm(strl:TStrings);     // 
}
var

  MemIniFile:TMemIniFile;


implementation
uses MainForm;

procedure BuildDevMenu();
var
    i:integer;
    DirPath:string;
    SearchRec:TSearchRec;
    IniList:TStringList;
    tmpLst:TStringList;

begin
  IniList:=TStringList.create;

  try
    //   
    DirPath:= ExtractFilePath(Application.EXEName); //    
    if (FindFirst(DirPath+'*.chp',faAnyFile,SearchRec)=0 ) then
    begin
      tmpLst:=TStringList.Create;
      try
        repeat
          tmpLst.LoadFromFile(DirPath+SearchRec.name);
          IniList.text:=IniList.text+tmpLst.Text;
        until (FindNext(SearchRec)<>0);
      finally
        tmpLst.Free;
        FindClose(SearchRec);
      end;
    end;

    MemIniFile.SetStrings(TStrings(IniList));

  //     

    MemIniFile.ReadSections(TStrings(IniList));
    //     
    for i:=0 to IniList.Count-1 do
    begin
      if ExtractWord(1,IniList.Strings[i],[' '])='Chip' then
        InsertToChipMenu(IniList.Strings[i])
    end;

  finally
    IniList.Free;
  end
end;

procedure StartConstructor(ChipName:string);
var nmClass:string;
    i:integer;
begin
    nmClass:=MemIniFile.ReadString('Chip '+ChipName,'InitClass','');
    for i:=0 to High(ConstructorsList) do
    begin
      if  ConstructorsList[i].name=nmClass then
        ConstructorsList[i].ClassName.CreateInPlace(frmMain.tshDevice,ChipName,frmMain.CommPort);
    end;
end;

procedure InsertToChipMenu(SectName:String);

  procedure InsertLevel(nmOwner:TMenuItem;lvl:String;N:Integer);
  var i:integer;
      Item:TMenuItem;
      nmItem:String;
      nmClass:String;
  begin
    nmItem:= MemIniFile.ReadString(sectName,lvl+IntToStr(N),'');
    if nmItem='' then
    begin
      nmClass:=MemIniFile.ReadString(sectName,'InitClass','');
      if nmClass<>'' then
      begin
        Item:=TMenuItem.Create(nmOwner);
        Item.caption:=MemIniFile.ReadString(sectName,'ItemCaption','');
//        Item.caption:=ExtractWord(2,sectName,[' ']);
        Item.name:=ExtractWord(2,sectName,[' ']);
        Item.OnClick:=frmMain.DeviceOpenExecute;
        nmOwner.insert(nmOwner.count,Item);
      end;
    end
    else
    begin
      Item:=nil;
      for i:=0 to nmOwner.Count -1 do
      begin
        if nmOwner.Items[i].Caption= nmItem then
        begin
          Item:=nmOwner.Items[i];
          break;
        end;
      end;

      if Item=Nil then
      begin
        Item:=TMenuItem.Create(nmOwner);
        Item.caption:=nmItem;
        nmOwner.insert(nmOwner.count,Item);
      end;
      InsertLevel(Item,lvl,N+1);
    end;

  end;


begin
  InsertLevel(frmMain.mnDevices,'Level',1);
end;


{
procedure ShowMemoForm(strl:Tstrings);
var frm:TForm;
    mem:TMemo;
begin
   frm:=TForm.Create(Application);
   mem:=TMemo.Create(frm);
   mem.parent:=frm;
   mem.Align:= alClient	;
   mem.Text:=strl.Text;
   mem.ScrollBars:=ssBoth;
   frm.ShowModal;
end;
}

initialization

  try
    MemIniFile:=TMemIniFile.create('');
  except
    Application.Terminate;
  end;
finalization

  MemIniFile.Free;

end.
