unit GridSettings;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, Mask, VCLUtils;

type
  TfrmGridSettings = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    BitBtn2: TBitBtn;
    dlgColor: TColorDialog;
    FontDialog1: TFontDialog;
    edFont: TEdit;
    sbtFont: TSpeedButton;
    sbtColor: TSpeedButton;
    sbtFixColor: TSpeedButton;
    shColor: TShape;
    shFixColor: TShape;
    dlgFixColor: TColorDialog;
    Bevel1: TBevel;
    cbVertD: TCheckBox;
    BitBtn3: TBitBtn;
    cbHorD: TCheckBox;
    cbVertA: TCheckBox;
    cbHorA: TCheckBox;
    K: TLabel;
    edColCount: TMaskEdit;
    edFixColW: TMaskEdit;
    Label4: TLabel;
    edFixRowH: TMaskEdit;
    Label5: TLabel;
    edDefColW: TMaskEdit;
    Label6: TLabel;
    edDefRowH: TMaskEdit;
    Label7: TLabel;
    procedure sbtFontClick(Sender: TObject);
    procedure sbtColorClick(Sender: TObject);
    procedure sbtFixColorClick(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure edColCountChange(Sender: TObject);
  private
    { Private declarations }
  public
    FGrid: TObject;
    procedure InitForm(Grid:TObject);
    { Public declarations }
  end;

var
  frmGridSettings: TfrmGridSettings;

implementation

uses HexGrid, Grids;
{$R *.DFM}

procedure TfrmGridSettings.sbtFontClick(Sender: TObject);
begin
  FontDialog1.Execute;
  edFont.font.name:=FontDialog1.font.name;
  edFont.text:=FontDialog1.font.Name+',  '+
     IntToStr(FontDialog1.font.size)+' pt';
end;

procedure TfrmGridSettings.sbtColorClick(Sender: TObject);
begin
   DlgColor.Execute;
   shColor.Brush.color:=DlgColor.color;
end;

procedure TfrmGridSettings.sbtFixColorClick(Sender: TObject);
begin
   DlgFixColor.Execute;
   shFixColor.Brush.color:=DlgFixColor.color;
end;

procedure TfrmGridSettings.InitForm(Grid:TObject);
begin
  FGrid:=Grid;
  try
  with THexGrid(FGrid) do
  begin
    FontDialog1.Font:=Font;
    DlgFixColor.Color:=shFixColor.Brush.Color;
    DlgColor.Color:=shColor.Brush.Color;
    edFont.text:=Font.Name;
    shColor.Brush.Color:=Color;
    shFixColor.Brush.Color:=FixedColor;
    if goVertLine in Options then
      cbVertD.Checked:=true else cbVertD.Checked:=false;
    if goHorzLine in Options then
      cbHorD.Checked:=true else cbHorD.Checked:=false;
    if goFixedVertLine in Options then
      cbVertA.Checked:=true else cbVertA.Checked:=false;
    if goFixedHorzLine in Options then
      cbHorA.Checked:=true else cbHorA.Checked:=false;
    edColCount.Text:=IntToStr(GridColCount);
    edFixColW.text:=IntToStr(ColWidths[0]);
    edDefColW.text:=IntToStr(DefaultColWidth);
    edFixRowH.text:=IntToStr(RowHeights[0]);
    edDefRowH.text:=IntToStr(DefaultRowHeight);
  end; {with}
  except
    on E:Exception do  MsgBox('Error',E.Message,0)
  end;

end;

procedure TfrmGridSettings.BitBtn3Click(Sender: TObject);
var tmpOptions: TGridOptions;
begin
  try
  with THexGrid(FGrid) do
  begin
    Color:=shColor.Brush.Color;
    FixedColor:=shFixColor.Brush.Color;
    Font:=FontDialog1.Font;
    tmpOptions:= THexGrid(FGrid).Options;
    if cbVertD.Checked then
      Include(tmpOptions ,goVertLine)
    else
      Exclude(tmpOptions, goVertLine);

    if cbHorD.Checked then
      Include(tmpOptions ,goHorzLine)
    else
      Exclude(tmpOptions, goHorzLine);

    if cbVertA.Checked then
      Include(tmpOptions ,goFixedVertLine)
    else
      Exclude(tmpOptions, goFixedVertLine);

    if cbHorA.Checked then
      Include(tmpOptions ,goFixedHorzLine)
    else
      Exclude(tmpOptions, goFixedHorzLine);

    Options:= tmpOptions;
    try
      GridColCount:=StrToInt(edColCount.Text)
    except
      GridColCount:=8;
    end;
    DefaultColWidth:=StrToInt(edDefColW.text);
    ColWidths[0]:=StrToInt(edFixColW.text);
    DefaultRowHeight:=StrToInt(edDefRowH.text);
    RowHeights[0]:=StrToInt(edFixRowH.text);


  end; {with}
  except
    on E:Exception do  MsgBox('Error',E.Message,0)
  end;
end;

procedure TfrmGridSettings.edColCountChange(Sender: TObject);
begin
  try
  if StrToInt(edColCount.Text)>256 then
    edColCount.Text:='256';
  except
  end;
end;


end.
