unit InProgress;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls, Buttons, RXCtrls, DevicesFrame, SendThread, RUtilites,
  Gauges;

type
  TfrmInProgress = class(TForm)
    Panel2: TPanel;
    BitBtn2: TBitBtn;
    Label2: TLabel;
    lbTimer: TLabel;
    Label3: TLabel;
    Timer: TTimer;
    Bevel1: TBevel;
    lbStatus: TRxLabel;
    Gauge: TGauge;
    procedure TimerTimer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    FfrmDevice:TfrmDevice;
    ProgrPos:Integer;
    procedure InitProcess;
    procedure ThreadDoneErr(var AMessage : TMessage); message WM_ThreadDoneErrMsg;
    procedure ThreadDoneOk(var AMessage : TMessage); message WM_ThreadDoneOkMsg;
    procedure InitGauge;
    procedure UpdateGauge;
  end;

var
  frmInProgress: TfrmInProgress;

implementation

{$R *.DFM}

procedure TfrmInProgress.TimerTimer(Sender: TObject);
var T:real;
begin
  T:=StrToFloat(lbTimer.caption);
  T:=T+Timer.Interval/1000;
  lbTimer.Caption:=Format('%5.1f',[T]);
end;

procedure TfrmInProgress.InitProcess;
begin
  with FfrmDevice do
  begin
    CheckSendThread;
    if Assigned(FProcessProc) then
      FSendThread.OnExecuteProcess:=FProcessProc;
    FSendThread.Resume;
  end;
end;



procedure TfrmInProgress.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  with FfrmDevice do
    if FSendThread<>Nil then
    begin
      FSendThread.Terminate;
      FSendThread.FEvent.SetEvent;
      repeat
        Application.ProcessMessages
      until FSendThread=nil;
    end;
  Action:=caFree;
end;


procedure TfrmInProgress.FormShow(Sender: TObject);
begin
  InitProcess
end;


procedure TfrmInProgress.ThreadDoneErr(var AMessage: TMessage);
begin
  ModalResult:=mrOk;
end;

procedure TfrmInProgress.ThreadDoneOk(var AMessage: TMessage);
begin
  ModalResult:=mrOk;
end;

procedure TfrmInProgress.InitGauge;
begin
 Gauge.Progress:=0;
end;

procedure TfrmInProgress.UpdateGauge;
begin
 Gauge.Progress:=ProgrPos;
// ed.text:=Format('%6d',[ProgrPos]);
// ed.text:=Format('%4d',[StrToInt(ed.text)+1]);

end;

end.
