unit PIC;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DevicesFrame, ImgList, StdCtrls, Mask, ToolEdit, ComboDigEdit, ComCtrls,
  CheckLst, ToolWin, ExtCtrls, VCLUtils, SendThread, RUtilites, HexGrid;


type
  TfrmMICROCHIP_PIC = class(TfrmDevice)
    procedure tbReadClick(Sender: TObject);
    procedure tbVerifyClick(Sender: TObject);
    procedure tbWriteClick(Sender: TObject);
    procedure tbEraseClick(Sender: TObject);
    procedure tbBlankCheckClick(Sender: TObject);
  private
  protected

    //     SendThread
    procedure Tr_ReadProcess;
    procedure Tr_WriteProcess;
    procedure Tr_EraseProcess;

  public

    constructor Create(AOwner: TComponent); override;

  end;

var
  frmMICROCHIP_PIC: TfrmMICROCHIP_PIC;

implementation
uses MainForm, InProgress;
{$R *.DFM}

constructor TfrmMICROCHIP_PIC.Create(AOwner: TComponent);
begin
  inherited;
  ChipClassID:='S 2';  //   
  frmMain.LoFirstOrder:=true;
end;




procedure TfrmMICROCHIP_PIC.tbReadClick(Sender: TObject);
begin
  self.FProcessProc:=Tr_ReadProcess;
  inherited;
end;

procedure TfrmMICROCHIP_PIC.tbVerifyClick(Sender: TObject);
begin
  self.FProcessProc:=Nil;
  inherited;
end;

procedure TfrmMICROCHIP_PIC.tbWriteClick(Sender: TObject);
begin
  self.FProcessProc:=Tr_WriteProcess;
  inherited;
end;

procedure TfrmMICROCHIP_PIC.tbEraseClick(Sender: TObject);
begin
  self.FProcessProc:=Tr_EraseProcess;
  inherited;
end;

procedure TfrmMICROCHIP_PIC.tbBlankCheckClick(Sender: TObject);
begin
  self.FProcessProc:=Nil;
  inherited;
end;

{
.................................................................

     SendThread

.................................................................
}
procedure TfrmMICROCHIP_PIC.Tr_ReadProcess;
var ArIndx:integer;
    DataBuf:array[0..127] of byte;
//    str:string;


  procedure ReadCONFIG(strID:string);
  var i,j:integer;
      strMask:string;
      b:word;
  begin
    ReadDataToBuf(ArIndx,DataBuf,' 2',2);
    b:=(DataBuf[0] shl 8) or DataBuf[1];
    //     
    //  
    for i:=0 to HIGH(NodesData) do
      if NodesData[i].strAreaID=strID then
      begin
        //   
        with trvParameters.Items[i] do
        begin
          if not HasChildren then break;
          //    
          for j:=0 to count-1 do
          begin
            strMask:=NodesData[Item[j].AbsoluteIndex].strMask ;
            if CompareWithMask(b,strMask) then
              SelectSubNode(trvParameters.Items[i],trvParameters.Items[i].Item[j]);
          end;
        end; {with }
      end;
  end;

  procedure ReadID;
  var indx:integer;
      st:string;
      b:word;
  begin
    ReadDataToBuf(ArIndx,DataBuf,' 2',4);
    //    ID
    b:=(DataBuf[0] and $f) shl 4;
    b:=(b or (DataBuf[1] and $f)) shl 4;
    b:=(b or (DataBuf[2] and $f)) shl 4;
    b:=b or (DataBuf[3] and $f);
    st:=Format('%4x',[b]);
    //      
    if FindNodeIndex('ID',indx) then
      trvParameters.Items[indx].Text:=NodesData[indx].strCapt+' : '+st;
  end;



begin
  with FSendThread do
  begin
    if not CommPort.Enabled then CommPort.Open;
    try
      PurgePort;
      TimeOuts(1000,1,1000,1,1000,1);
      SetEventChar(#10);
      for ArIndx:=0 to lsvAreas.Items.Count-1 do
        If lsvAreas.Items[ArIndx].Checked then
        begin
          if AreasData[ArIndx].strID='CODE' then ReadDataToGrid(ArIndx,frmMain.CodeGrid,'',2);
          if AreasData[ArIndx].strID='EEPROM' then ReadDataToGrid(ArIndx,frmMain.EEPROMGrid,' 1',4);
          if AreasData[ArIndx].strID='CONFIG' then ReadCONFIG('CONFIG');
          if AreasData[ArIndx].strID='ID' then ReadID;
        end;
    finally
      CommPort.Close;
      //   InProgress
      PostMessage(frmInProgress.Handle,wm_ThreadDoneErrMsg,0,0);
    end;
  end; {with FSendThread}
end;



procedure TfrmMICROCHIP_PIC.Tr_WriteProcess;
var ArIndx:integer;
//    DataBuf:array[0..127] of byte;


  procedure WriteCONFIG(strID:string);
  var i:integer;
      strMask:string;
      b:word;
  begin
    b:=0;
    //     
    //  
    for i:=0 to HIGH(NodesData) do
      if NodesData[i].strAreaID=strID then
      begin
        //   
        with trvParameters.Items[i] do
        begin
          if not HasChildren then break;
          strMask:=NodesData[NodesData[i].intSelSubIt].strMask ;
          b:=SetByMask(b,strMask);
        end; {with }
      end;
      WriteDataFromStr(ArIndx,Format('%.4x',[b]),' 2');
  end;

  procedure WriteID;
  var indx:integer;
      b:word;
      st:string;
  begin
    //      
//    b:=$ffff;
    if FindNodeIndex('ID',indx) then
    begin
      st:=trvParameters.Items[indx].item[0].text;
      b:=StrToInt('$'+st);
      st:=Format('%.4x',[((b shr 12) and $F) or $3FF0]);
      st:=st+Format('%.4x',[((b shr 8) and $F) or $3FF0]);
      st:=st+Format('%.4x',[((b shr 4) and $F) or $3FF0]);
      st:=st+Format('%.4x',[(b and $F) or $3FF0]);
      WriteDataFromStr(ArIndx,st,' 2');
    end;
  end;


begin
  with FSendThread do
  begin
    if not CommPort.Enabled then CommPort.Open;
    try
      PurgePort;
      TimeOuts(1000,1,1000,1,1000,1);
    //  SetEventChar(#10);
      for ArIndx:=0 to lsvAreas.Items.Count-1 do
        If lsvAreas.Items[ArIndx].Checked then
        begin
          if AreasData[ArIndx].strID='CODE' then
            WriteDataFromGrid(ArIndx,frmMain.CodeGrid,'',2);
          if AreasData[ArIndx].strID='EEPROM' then
            WriteDataFromGrid(ArIndx,frmMain.EEPROMGrid,' 1',4);
          if AreasData[ArIndx].strID='CONFIG' then
            WriteCONFIG('CONFIG');
          if AreasData[ArIndx].strID='ID' then
            WriteID;
        end;
    finally
      CommPort.Close;
      //   InProgress
      PostMessage(frmInProgress.Handle,wm_ThreadDoneErrMsg,0,0);
    end;
  end; {with FSendThread}
end;

procedure TfrmMICROCHIP_PIC.Tr_EraseProcess;
var str,cmdStr:string;
begin
  with FSendThread do
  begin
    if not CommPort.Enabled then CommPort.Open;
    try
      PurgePort;
      TimeOuts(1000,1,1000,1,1000,1);
      cmdStr:='E 0 FF'+#13;
      WriteStrToComm(cmdStr);
      ReadNChar(str,Length(cmdStr)+3);
      if (cmdStr+#13+#10+'>')<>str then
        Raise Exception.Create(strIsNotValidAnswer);
    finally
      CommPort.Close;
      //   InProgress
      PostMessage(frmInProgress.Handle,wm_ThreadDoneErrMsg,0,0);
    end;
  end; {with FSendThread}
end;









initialization
  SetLength(ConstructorsList, Length(ConstructorsList)+1);
  ConstructorsList[High(ConstructorsList)].name:='TfrmMICROCHIP_PIC';
  ConstructorsList[High(ConstructorsList)].ClassName:=TfrmMICROCHIP_PIC;
end.
