unit PerfomanceTest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Mask, Buttons, RUtilites;

type
  TfrmPerfomanceTest = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    edLoopCount: TMaskEdit;
    Label1: TLabel;
    edCurFr: TEdit;
    Label2: TLabel;
    edStart: TEdit;
    Label3: TLabel;
    edEnd: TEdit;
    Label4: TLabel;
    edTime: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    edCPUspeed: TEdit;
    Label7: TLabel;
    edTime2: TEdit;
    procedure BitBtn1Click(Sender: TObject);
  private

  public
    Frequency: TLargeInteger;
    lpPerformanceCount1: TLargeInteger;
    lpPerformanceCount2: TLargeInteger;

  end;

var
  frmPerfomanceTest: TfrmPerfomanceTest;

implementation

{$R *.DFM}

procedure TfrmPerfomanceTest.BitBtn1Click(Sender: TObject);
var i,N:LongInt;
  PriorityClass,Priority: Integer;
  adjustment:longint;
  StartTime,EndTime,StartTime1,EndTime1: Int64;
  CPUSpeed: Double;
const
  CalibrateDelayTime = 500; // Time for calibation in ms




begin
  N:= StrToInt(edLoopCount.Text);
  QueryPerformanceFrequency(Frequency);
  PriorityClass:=GetPriorityClass(GetCurrentProcess);
  Priority:=GetThreadPriority(GetCurrentThread);
  SetPriorityClass(GetCurrentProcess,REALTIME_PRIORITY_CLASS);
  SetThreadPriority(GetCurrentThread,{THREAD_PRIORITY_TIME_CRITICAL}31);

  QueryPerformanceCounter(lpPerformanceCount1);
  QueryPerformanceCounter(lpPerformanceCount2);
  adjustment:=lpPerformanceCount2- lpPerformanceCount1;

  QueryPerformanceCounter(lpPerformanceCount1);
  for i:=1 to N do;
  QueryPerformanceCounter(lpPerformanceCount2);

  Sleep(10);
  StartTime:=GetTSC;
  Sleep(CalibrateDelayTime);
  EndTime:=GetTSC;

  StartTime1:=GetTSC;
  for i:=1 to N do;
  EndTime1:=GetTSC;

  SetThreadPriority(GetCurrentThread,Priority);
  SetPriorityClass(GetCurrentProcess,PriorityClass);
  CPUSpeed:=(EndTime - StartTime) / (CalibrateDelayTime*0.001);
  edTime2.text:=Format('%.3f',[(EndTime1- StartTime1)*1000000/CPUSpeed]);;
  edCPUspeed.Text:=Format('%.3f',[CPUSpeed/1000000]) ;
  edCurFr.text:=IntToStr(Frequency);
  edStart.text:=IntToStr(lpPerformanceCount1);
  edEnd.text:=IntToStr(lpPerformanceCount2);
  edTime.text:=Format('%.3f',[(lpPerformanceCount2- lpPerformanceCount1-adjustment)*1000000/Frequency]);
end;

end.
