unit PortSettings;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, CommInt;

type
  TfrmPortSettings = class(TForm)
    Label1: TLabel;
    cbPort: TComboBox;
    cbSpeed: TComboBox;
    Label2: TLabel;
    Label3: TLabel;
    cbDataBits: TComboBox;
    Label4: TLabel;
    cbStopBits: TComboBox;
    Label5: TLabel;
    cbParity: TComboBox;
    Label6: TLabel;
    cbFlowControl: TComboBox;
    Bevel1: TBevel;
    bbOk: TBitBtn;
    BitBtn1: TBitBtn;
    procedure bbOkClick(Sender: TObject);
  private
    Port: Tcomm;
    { Private declarations }
  public
    constructor CreatePortSettings(AOwner: TComponent;APort: TComm);
    { Public declarations }
  end;

var
  frmPortSettings: TfrmPortSettings;

implementation

{$R *.DFM}

constructor TfrmPortSettings.CreatePortSettings(AOwner: TComponent;APort: TComm);
begin
  inherited Create(AOwner);
  Port:=APort;
  cbPort.ItemIndex:=cbPort.Items.IndexOf(Port.DeviceName);
  cbSpeed.ItemIndex:=Ord(Port.BaudRate);
  cbDataBits.ItemIndex:=Ord(Port.DataBits);
  cbStopBits.ItemIndex:=Ord(Port.StopBits);
  cbParity.ItemIndex:=Ord(Port.Parity);
  cbFlowControl.ItemIndex:=Ord(Port.FlowControl);
end;

procedure TfrmPortSettings.bbOkClick(Sender: TObject);
begin
  Port.DeviceName:=cbPort.Text;
  Port.BaudRate:=TBaudrate(cbSpeed.ItemIndex);
  Port.DataBits:=TDatabits(cbDataBits.ItemIndex);
  Port.StopBits:=TStopbits(cbStopBits.ItemIndex);
  Port.Parity:=TParity(cbParity.ItemIndex);
  Port.FlowControl:=TFlowControl(cbFlowControl.ItemIndex);
end;

end.
