;********************************************************************
;* The`s programm for project "DOOR1".                              *
;* The`s controller of door alarm signalling system.                *
;* Controller intered for ficsation and remember attempts open      *
;* lock of door, and generation sound by attempts open lock end     *
;* open door.                                                       *
;* Chapters:                                                        *
;* P3.2 - hard interupt, output amplifier and detector sound        *
;*        attempts open lock of door.                               *
;* P1.7 - output of controller for sound amplifier.                 *
;* P1.6 - output of controller for LED - ficsator.                  *
;* P1.5 - output of controller for relase output.                   *
;* P1.4 - input of controller for door sensor.                      *
;* P1.3 - input of controller for scan button.                      *
;********************************************************************
;
;
;********************************************************************
;*  Declarations                                                    *
;********************************************************************
;
         SOUND          BIT     P1.7
         IND            BIT     P1.6
         ALARM          BIT     P1.5
         DOOR           BIT     P1.4
         SCANBAT        BIT     P1.3
         FLAG_D         EQU     01AH
         FLAG_S         EQU     01BH
         FLAG_A         EQU     01CH
;
;********************************************************************
;*  Start                                                           *
;********************************************************************
;
        JMP             INIT           ; start adressable
        ORG             0003H          ; hard interupt
        JMP             LOCK           ; adressable
;
;********************************************************************
;*  Initialisation                                                  *
;********************************************************************
;
INIT:   MOV             SBUF, #0CCH    ; load WDT
        CLR             FLAG_D         ; ficsator door
        CLR             FLAG_S         ; ficsator scan batton
        CLR             FLAG_A         ; ficsator alarm signal
        MOV             R6, #000H      ; counter LOCK
;
;********************************************************************
;*  Main programm                                                   *
;********************************************************************
;
CYCLE:          MOV     TMOD, #00001000B    ; configuration hard
                MOV     TCON, #00000001B    ; interupt
                MOV     IP, #00001000B
                MOV     SP, #060H           ; head stack
                MOV     IE, #10000001B      ; anable interupt
                CALL    SCAN                ; run scan door and button
                MOV     IE, #00000000B      ; disable interupt
                JNB     FLAG_D, M12         ; control door
                MOV     A, R6               ; calculation mode sound
                CLR     C
                ADD     A, #0F8H
                JC      M13
M15:            MOV     R5, #002H
M14:            CLR     FLAG_D
                CALL    TIK                 ; generation sound 3 signals
                CALL    MIL100              
                MOV     A, R5
                DEC     R5
                JNZ     M14
                CALL    SEC1
                JB      FLAG_D, M15         ; stop sound?
                JMP     M12
M13:            CLR     IND                 ; on light IND
                MOV     R5, #01FH
M16:            CLR     FLAG_D
                CALL    TIK                 ; generation sound 32 signals
                CALL    MIL100              
                MOV     A,R5
                DEC     R5
                JNZ     M16
                CALL    SEC1                
                JB      FLAG_D, M13
;
M12:            MOV     A, R6
                JZ      M17                 ; disable scan R6, if R6=0 
                JNB     FLAG_S, M17         ; control counter 
                SETB    IND                 ; of alarms lock
                CALL    SEC1
                CLR     FLAG_S
                MOV     A, R6
M18:            MOV     R7, A               ; R7 used as stack A 
                CLR     IND
                CALL    TIK
                SETB    IND
                CALL    SEC1
                MOV     A, R7
                DEC     A
                JNZ     M18
                CLR     FLAG_S
M17:            JB      FLAG_A, M19         ; alarm on and off?
                MOV     A, R6
                CLR     C
                ADD     A, #0F4H
                JNC     M19
                CLR     ALARM
                CALL    SEC1
                SETB    ALARM
                SETB    FLAG_A              
M19:            JMP     CYCLE               ; return on begin
;
;********************************************************************
;  Subprogramms                                                     *
;********************************************************************
;
SCAN:           MOV     SBUF, #0CCH         ; subprogramm scan
                JNB     DOOR, M1            ; door end scan button
                CALL    MIL50               ; and set ficsators
                JNB     DOOR, M1
                SETB    FLAG_D
M1:             JB      SCANBAT, M2
                CALL    MIL50
                JB      SCANBAT, M2
                SETB    FLAG_S
M2:             RET
;
MIL50:          MOV     IE, #00000000B      ; delay 50ms
                MOV     TCON, #00000000B
                MOV     TMOD, #00100000B
                MOV     TH1, #001H
                MOV     R2, #0A0H
M3:             CLR     TF1
                SETB    TR1
                JNB     TF1, $
                CLR     TR1
                MOV     A, R2
                DEC     R2
                JNZ     M3
                RET
;
MIL100:         MOV     R3, #002H          ; delay 1
M4:             CALL    MIL50
                CALL    SCAN
                MOV     A, R3
                DEC     R3
                JNZ     M4
                RET
;
SEC1:           MOV     R3, #014H          ; delay 2
M5:             CALL    MIL50
                CALL    SCAN
                MOV     A, R3
                DEC     R3
                JNZ     M5
                RET
;
SEC5:          MOV     R3, #064H          ; delay 3
M6:             CALL    MIL50
                CALL    SCAN
                MOV     A, R3
                DEC     R3
                JNZ     M6
                RET
;
TIK:            MOV     TCON, #00000000B  ; generation sound
                MOV     TMOD, #00100000B
                MOV     TH1, #059H
                MOV     R2, #06AH
M10:            CLR     TF1
                SETB    TR1
                JNB     TF1, $
                CLR     TR1
                CPL     SOUND
                MOV     A, R2
                INC     R2
                JNZ     M10
                SETB    SOUND   
                RET
;
LOCK:           PUSH    IE                ; making hard 
                PUSH    PSW               ; interupt from
                PUSH    ACC               ; lock of door and
                PUSH    TMOD              ; generation sound
                PUSH    TCON
                PUSH    IP
                INC     R6
                MOV     R5, #001H
M9:             CALL    TIK
                CALL    MIL100
                JB      FLAG_D, M11
                MOV     A, R5
                DEC     R5
                JNZ     M9
                CALL    SEC5
M11:            POP     IP
                POP     TCON
                POP     TMOD
                POP     ACC
                POP     PSW
                POP     IE
                RETI
;
END
                                                                                                           




