#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <string.h>
#include <ctype.h>
#include <dir.h>
#include <bios.h>

#define LOAD_CONFIG    0
#define LOAD_DATA      2
#define READ_DATA      4
#define INC_ADDR       6
#define BEGIN_PROG     8
#define END_PROG       14 // ⮫쪮  166...
#define LOAD_DATA_DM   3  // ⮫쪮  16c/f8...
#define READ_DATA_DM   5  // ⮫쪮  16/f8...
#define MAX_PIC_CMD   63  // division between pic and programmer commands

#define RESET         64  // external reset command, not neded for programming
#define PROGRAM_MODE  65  // initialize program mode
#define RUN           66  //  PIC

#define PROGMR_ERROR  -2

#define PTR            0  // use device #0

#define BSIZE 0x2200          // 㧪
#define EPROM 4            //砫 EPROM PIC
#define MAXPIC 6           //Max tippic

typedef unsigned char byte;
byte checksum;
FILE *inputfile;
FILE *outputfile;
byte filename[MAXPATH]="";         //ᨢ     䠩
unsigned int progbuf[BSIZE];         // 
byte tippic=6;                 // PIC:
			     //0 - 16C83
			     //1 - 16C84
			     //2 - 16F83
			     //3 - 16F84
			     //4 - 16CE623
			     //5 - 16CE624
			     //6 - 16CE625
unsigned int progMemSize[7] = {0x200, 0x400, 0x200, 0x400, 0x200, 0x400, 0x800};
			     //      ணࠬ
byte oblmem=1;               //    .   ࠭
                             //1 - Program mem
			     //2 - ID, Config
			     //3 - Data mem
int demo;                    //=0 - OK, !=0 - ணࠬ  祭

void Menu(void);
void Dump(unsigned int Beg,byte newoblmem);
void vihod(void);                    //室
byte vvodFname(byte *string);     //  䠩
byte pathName(void);                 //祭    ⥬
unsigned int vvod4Hex(unsigned int vvod);      // 4- HEX 
char readihex(void);                 //㧪 HEX 䠩
char writePIC(void);               // HEX 䠩  ᮤন PIC
void pechatPic(void);              // ⨯ PIC
int ser_pic16(int cmd, int data);   //㧪   ணࠬ
void rdPrg(unsigned int Addr, unsigned int Addrmax);  //⥭ PROG
void rdId(void);                                //⥭ ID, CONFIG
void rdData(unsigned int Addr, unsigned int Addrmax); //⥭ DATA
unsigned int verPrg(unsigned int Addr, unsigned int Addrmax); //ࠢ PROG
unsigned int verId(void);                       //ࠢ ID, CONFIG
unsigned int verData(unsigned int Addr,unsigned int Addrmax); //ࠢ DATA
unsigned int blankPrg(unsigned int Addr, unsigned int Addrmax);
unsigned int blankId(void);
unsigned int blankData(unsigned int Addr,unsigned int Addrmax);
unsigned int verPic(void);                    //ࠢ PIC  ஬
unsigned int blankPic(void);                  //஢ઠ PIC  
unsigned int wrData(unsigned int Addr,unsigned int Addrmax); // DATA Memory
unsigned int wrPrg(unsigned int Addr,unsigned int Addrmax); // PROG
unsigned int wrID(void);                   // ID, CONFIG
void wrCEprom(unsigned int data);     //  EPROM
void errwr(unsigned int err);       // ᮮ.  訡  PIC
void helpPrg(void);                 //뢮 Help

//**************************MAIN*************************
void main(int argc, byte *argv[])
{
  unsigned int Addr=0;
  unsigned int Key=0;
  int i;
     for (i=0; i<BSIZE; ++i)		     // ᨢ FFFF
	progbuf[i]=0x3fff;
     demo = ((biosprint(1,0,PTR) & 0xb8) ^ 0x90);    //᫨=0, - ணࠬ 祭
     clrscr();
     if (demo)
	{  printf("\n  LPT1  祭 ணࠬ!"
		  "\n, १ ᪮쪮 ᥪ㭤 DEMO ०...\n");
	   delay(6000);
	}
     if (argc > 1)
	 { strcpy(filename,argv[1]);
	   if (readihex())
	      { printf("\n\n訡 ⥭ HEX 䠩   ப.\n\  ");
		getch(); filename[0]=0; }     //訡 ⥭ HEX 䠩  . ப
	}
     _setcursortype(_NOCURSOR);
   textattr(0x1e);

   clrscr();
   Dump(Addr,oblmem);

   while (1)
   {
   if (Key==27)
      {	vihod(); textattr(0x1e); }
   Key=0;
   Key=getch();
//   gotoxy(70,24);
//   printf("%2d    ",Key);

   if(Key==0)
   {  Key = getch();
//	 gotoxy(72,24);
//	 printf("%2d",Key);

            switch(Key){
		case 59: helpPrg(); break;                     //F1
                case 60: clrscr();Dump(Addr=0x0000,oblmem=1);break; //F2
		case 62: if (tippic<EPROM)
			     { clrscr();Dump(Addr=0x2100,oblmem=3); }
			 break;                                     //F4
                case 61: clrscr();Dump(Addr=0x2000,oblmem=2);break; //F3
		case 63: {  if (oblmem==1 || oblmem==2)             //F5
			   { window(1,25,80,25);
			     textattr(0x71);
			     clrscr();
			     gotoxy(69,1);
			     cprintf("Enter");
			     textattr(0x70);
			     cprintf("  Exit");
			   }
			    if (oblmem==1)
			 {  window (28,10,56,12);
			    clrscr();
			    gotoxy(8,2); cprintf("Address: ");
			    Addr = (vvod4Hex(Addr) & 0xff80);
			    if (Addr > 0x1f80)
				Addr=0x1f80;
                            window(1,1,80,25);
                            textattr(0x1e); clrscr();
                            Dump(Addr,1);
                          }
			    if (oblmem==2)
			  { window (14,12,63,13);
			    clrscr();
			    gotoxy(13,1); cprintf("஢ (xxxx, Enter)\n\r  2000:  ");
			    i=wherex();
			    for (Addr=0x2000;Addr<0x2004;Addr++)
			       {  progbuf[Addr] = vvod4Hex(progbuf[Addr]);
				  gotoxy((i+=5),2);
			       }
			    Addr+=3;
			    printf("---- ---- ---- ");
			    progbuf[Addr] = vvod4Hex(progbuf[Addr]);
			    window(1,1,80,25);
			    textattr(0x1e); clrscr();
			    Dump(Addr=0x2000,2);
			  }
			    break;
                          }
	       case 68: { Menu();                            //F10
			  textattr(0x1e); clrscr();
			  if (oblmem == 2)
			      Dump(Addr=0x2000,oblmem);
			  else if (oblmem == 3)
				  Dump(Addr=0x2100,oblmem);
			  else Dump(Addr=0,oblmem=1);
			 }    break;
	       case 73: if (oblmem==1)
			     {  if(Addr>127)
				     Addr-=128;
				else Addr=0;
				Dump(Addr,oblmem); }
				break;
	       case 81: if (oblmem==1)
			     {  if(Addr < 0x1f80)
				     Addr+=128;
				 else Addr=0x1f80;
				 Dump(Addr,oblmem); }
				 break;
			   }
   }    }    }

void del100(void)                 //প 100
{  _AH=0x86;
   _CX=0;
   _DX=100;
   geninterrupt(0x15);
}

int mygetch(void)                 //⪠  
{  while (kbhit())
     getch();
   return getch();
}

byte Dread(unsigned int Adr)      //⥭  DATAmem
{ return (progbuf [Adr]); }

void Dump(unsigned int Beg,byte newoblmem)       //. , . 
{ unsigned int addr;
  byte i=0,j=0;
pechatPic();
textattr(0x20);
gotoxy(10,1);
cprintf("    ணࠬ ஫஢ PIC16C/Fxxx (U = 12...14v)   ");
textattr(0x70);
gotoxy(1,25);
cprintf("    Help     ProgMem     Config                 Address      Menu         Exit ");
gotoxy(49,25);
if (newoblmem == 2)     //ID
   cprintf("Edit   ");
if (newoblmem == 3)
 {  textcolor(8);     //Data
    cprintf("Address");
 }
if (tippic >= EPROM)
   textcolor(8);    //DataMem ⮫쪮  FLASH
else textcolor(0);
gotoxy(37,25);
cprintf("DataMem");
textcolor(1);
gotoxy(2,25);
cprintf("F1");
gotoxy(11,25);
cprintf("F2");
gotoxy(23,25);
cprintf("F3");
gotoxy(34,25);
cprintf("F4");
gotoxy(46,25);
cprintf("F5");
gotoxy(58,25);
cprintf("F10");
gotoxy(71,25);
cprintf("Esc");

addr=Beg;
textattr(0x1e);
switch (newoblmem)
   {
   case 3 : textcolor(12);
	    gotoxy(35,8);
	    cprintf("Data Memory");
	    textcolor(14);
for(j=0;j<4;j++)         //뢮  
    {
gotoxy(12,10+j);
cprintf(" %04X:  ",(addr-0x2100));
for(i=0;i<16;i++)
   { gotoxy(20+i*3,10+j);cprintf("%02X ",Dread(addr++));
   }
    } break;

   case 2 :   textcolor(12);
	      gotoxy(23,8);
	      cprintf("ID Location and Configuration Word");
	      textcolor(14);
   gotoxy(15,10);            //뢮 CONFIG  ID
   cprintf(" %04X:  ",addr);
   for(i=0;i<4;i++)
	{ gotoxy(23+i*5,10);cprintf("%04X ",progbuf[addr++]);
	}
   gotoxy(43,10);cprintf("---- ---- ---- ");
		cprintf("%04X ",progbuf[addr+3]);
   break;

   case 1 :   textcolor(12);
	      gotoxy(33,4);
	      cprintf("Program Memory");
	      textcolor(14);
   for (j=0;j<16;j++)      //뢮  PROGMEM
   {
   gotoxy(15,6+j);
  cprintf(" %04X: ",addr);
   for(i=0;i<8;i++)
 { gotoxy(23+i*5,6+j);cprintf("%04X ",progbuf[addr++]); }
   }  }  }

int Menu_pop(char *str[])
{ void *buf;
  int pos=0,num=0,maxlen=0,i=0,Key=0;
  int x,y,flag=-1;
  x=wherex()-2;
  y=wherey();

  while(str[num]!=0)
  {if(maxlen<strlen(str[num]))maxlen=strlen(str[num]);
   num++;}

  num--;
  buf=malloc(num*maxlen*2);if(buf==0){return -1;}
  if((x+maxlen+2)>80) x=80-maxlen-2;
  y++;
  if((y+num+2)>24) y=24-num-2;
  gettext(x,y,x+maxlen+2,y+num+2,buf);

  textattr(0x70);
for(i=0;i<=num;i++){ gotoxy(x,y+i);cprintf(str[i]);}

textattr(0x30);
gotoxy(x,y+pos);cprintf(str[pos]);

   while (Key!=27)
   { Key=0;
   Key=getch();
   if (Key==13) { Key=27;flag=pos;}
   if (Key==0)  {
		textattr(0x70);gotoxy(x,y+pos);cprintf(str[pos]);
		Key = getch();
		switch(Key){
			case 72: if(pos>0)pos--;else pos=num;break;
                        case 80: if(pos<num)pos++;else pos=0;break;
                        case 75: Key=27;flag=275;break;
                        case 77: Key=27;flag=277;break;
                        case 33: Key=27;flag=133;break; //Alt-F
			case 19: Key=27;flag=119;break; //Alt-R
			case 47: Key=27;flag=147;break; //Alt-V
			case 17: Key=27;flag=117;break; //Alt-W
			case 32: Key=27;flag=132;break; //Alt-D
			case 34: Key=27;flag=134;break; //Alt-G
			     }
textattr(0x30);gotoxy(x,y+pos);cprintf(str[pos]);
   }
   }
  puttext(x,y,x+maxlen+2,y+num+2,buf);
  return flag;
}

void Menu()
{
    byte buf [160];
    byte buf1 [500];
    byte cx, cy, j;
    unsigned int err;
	int pos=0,num=5;
	int place[]={1,6,9,20,22,33,35,46,48,54,59,64};
	int i,Key;
	char *string[]={" File "," Read       "," Verify     "," Write      "," Device  "," Go    ",0};
	char *string1[]={" Load ",
					 " Save ",
					 " Quit ",0};
	char *string2[]={" All memory ",
					 " ProgMemory ",
					 " ID, Config ",
					 " DataMemory ",0};
	char *string3[]={" All memory ",
					 " Blank ?    ",0};
	char *string4[]={" All memory ",
					 " ProgMemory ",
					 " ID, Config ",
					 " DataMemory ",
					 " Erase      ",0};
	char *string5[]={" 16C83   ",
					 " 16C84   ",
					 " 16F83   ",
					 " 16F84   ",
					 " 16CE623 ",
					 " 16CE624 ",
					 " 16CE625 ",0};
	char *string6[]={" Go    ",
					 " Reset ",0};
if (tippic>=EPROM)
     string2[3] = string4[3] = 0;

gettext(1,1,80,1,buf);

textattr(0x70);
gotoxy(1,1);
clreol();
for(i=0;i<=num;i++){gotoxy(place[i*2],1);cprintf(string[i]);}
textattr(0x71);
for(i=0;i<=num;i++){gotoxy(place[i*2]+1,1);cprintf("%c",string[i][1]);}

textattr(0x71);
gotoxy(1,25);
cprintf("  Up  Down  Right  Left      Enter                                   Esc       ");
textattr(0x70);
gotoxy(75,25);
cprintf("Exit");


textattr(0x30);
gotoxy(place[pos*2],1);cprintf(string[pos]);
textattr(0x31);
gotoxy(place[pos*2]+1,1);cprintf("%c",string[pos][1]);
   while (Key != 27)
   { Key=0; i=-1;
   Key=getch();
		       if (Key==13) switch(pos)
						{ case 0: i=Menu_pop(string1);break;
						  case 1: i=Menu_pop(string2);break;
						  case 2: i=Menu_pop(string3);break;
						  case 3: i=Menu_pop(string4);break;
						  case 4: i=Menu_pop(string5);break;
						  case 5: i=Menu_pop(string6);break;
						}
						if(i>100){Key=0;ungetch(i-100);
							 }
						gotoxy(place[pos*2]+2,1);
   if(Key==0)
   {    Key = getch();
textattr(0x70);gotoxy(place[pos*2],1);cprintf(string[pos]);
textattr(0x71);gotoxy(place[pos*2]+1,1);cprintf("%c",string[pos][1]);
		switch(Key){
                        case 75:  if(pos>0)pos--;else pos=num;break;
                        case 77:  if(pos<num)pos++;else pos=0;break;
                        case 175: if(pos>0)pos--;else pos=num;ungetch(13);break;
                        case 177: if(pos<num)pos++;else pos=0;ungetch(13);break;
                        case 33: pos=0;ungetch(13);break; //Alt-F
			case 19: pos=1;ungetch(13);break; //Alt-R
			case 47: pos=2;ungetch(13);break; //Alt-V
			case 17: pos=3;ungetch(13);break; //Alt-W
			case 32: pos=4;ungetch(13);break; //Alt-D
			case 34: pos=5;ungetch(13);break; //Alt-G
				   }
textattr(0x30);gotoxy(place[pos*2],1);cprintf(string[pos]);
textattr(0x31);gotoxy(place[pos*2]+1,1);cprintf("%c",string[pos][1]);
   }
   cx=wherex();    // ࠭  
   cy=wherey();

   switch(pos) {
      case 0: { if (i==2)                   //Menu File
		  vihod();
		if ((i==0) || (i==1))
		    { gettext(1,10,80,12,buf1);
		      textattr(0x70);
		      window(1,10,80,12);
		      clrscr();
		      if (i==1)
			 cprintf ("\n  ࠭ 䠩: ");
			 else
			 cprintf ("\n  㧨 䠩: ");
		      j = pathName();
		      if ((i==1) && (j==13))
		  {     clrscr();
			if (writePIC())         // 䠩
			  {  getch(); filename[0]=0; }
			else   ungetch(27);     //室  ᯥ譮 
		  }
		      if ((i==0) && (j==13))
		  {     clrscr();
			for (i=0; i<BSIZE; ++i)	 // ᨢ FFFF
			   progbuf[i]=0x3fff;
			if (readihex())         //⥭ 䠩
			  {  getch(); filename[0]=0; }	  //訡,   .
			else   ungetch(27);     //室    ᯥ. ⥭
		  }
		      window(1,1,80,25);
		      puttext(1,10,80,12,buf1);
		    }
		 break;  }
      case 4:    if ((i>=0)&&(i<=MAXPIC))
		  {  if (i>=EPROM)
			string2[3] = string4[3] = 0;
		     else  string2[3] = string4[3] = " DataMemory ";
		     tippic=i;
		     pechatPic(); }
		 break;
      case 5:    if (!demo)
		   {  if (i == 0)
			ser_pic16(RUN,0);
		      if (i == 1)
			ser_pic16(RESET,0);
		   }
		 break;
      case 1:    if ((!demo) && (i<4) && (i>=0))
		   { window(26,14,53,17);
		     textattr(0x70);
		     clrscr();
		     cprintf("\n   ⥭ PIC   ");
		     window(1,1,80,25);
		     ser_pic16(PROGRAM_MODE,0);
		     switch(i)
		      { case 0:
				{ rdPrg(0,progMemSize[tippic]);  //⥭ PROG
				  rdId();                        //⥭ ID, CONFIG
				  if (tippic < EPROM)
				    {  ser_pic16(PROGRAM_MODE,0);
				       rdData(0x2100,0x2140);   //⥭ DATA
				    }
				   oblmem = 1;
				   ungetch(27);    //DUMP PROGMEM
				 } break;
			 case 1:
				 { rdPrg(0,progMemSize[tippic]);
				   oblmem = 1;
				   ungetch(27);
				 } break;
			 case 2:  rdId(); oblmem = 2; ungetch(27); break;
			 case 3: {
				   rdData(0x2100,0x2140);
				   oblmem = 3;
				   ungetch(27);
				 } break;
		       }         ser_pic16(RESET,0);
		    } break;                       // ⥭
	case 2:    if ((!demo) && (i==0 || i==1))    //verify
		     {    gettext(23,14,56,20,buf1);
			  textattr(0x70);
			  window(23,14,56,20);
			  clrscr();
			  ser_pic16(PROGRAM_MODE,0);
			  if (i==0)                 // All memory
			      verPic();
			  if (i==1)                 // Blank ?
			      blankPic();
			  cprintf("\n        ");
			  mygetch();
			  window(1,1,80,25);
			  puttext(23,14,56,20,buf1);
		      } break;
	case 3: if ((!demo) && (i<5) && (i>=0))    //Write
		  {  gettext(23,14,56,20,buf1);
		     textattr(0x70);
		     window(23,14,56,20);
		     clrscr();
		     ser_pic16(PROGRAM_MODE,0);
		     switch(i)
		  {
		       case 4:  {   ser_pic16(LOAD_CONFIG,0x3fff);  //࠭ 1684
				    for (j=0; j<7; j++)
				       ser_pic16(INC_ADDR,0);
				    ser_pic16(1,0);
				    ser_pic16(7,0);
				    ser_pic16(BEGIN_PROG,0);
				    delay(13);
				    ser_pic16(1,0);
				    ser_pic16(7,0);
				    ser_pic16(PROGRAM_MODE,0);
				    blankPic();
				    cprintf("\n        ");
				    mygetch();
				 }  break;
		       case 3:   {  err = wrData(0x2100,0x2140); // DATA 16C84
				    ser_pic16(RESET,0);
				    if (err)          // , 訡+1
				      errwr(err);     // ᮮ饭
				 }  break;
		       case 2:   {  err = wrID();	// ID, CONFIG
				    ser_pic16(RESET,0);
				    if (err)
				      errwr(err);
				 }   break;
		       case 1:   {  err = wrPrg(0,progMemSize[tippic]);  // PROGMEM
				    ser_pic16(RESET,0);
				    if (err)
				      errwr(err);
				 }  break;
		       case 0:   {  err = wrPrg(0,progMemSize[tippic]);  // PROGMEM
				    ser_pic16(RESET,0);
				    if (err)
				      {  errwr(err); break; }
				    if (tippic<EPROM)
				      {  clrscr();
					 ser_pic16(PROGRAM_MODE,0);
					 err = wrData(0x2100,0x2140); // DATA 16C84
					 ser_pic16(RESET,0);
					 if (err)
					   {  errwr(err); break; }
				      }
				    clrscr();
				    ser_pic16(PROGRAM_MODE,0);
				    err = wrID();	// ID, CONFIG
				    ser_pic16(RESET,0);
				    if (err)
				      {  errwr(err); break; }
				    clrscr();
				    ser_pic16(PROGRAM_MODE,0);
				    verPic();
				    cprintf("\n        ");
				    mygetch();
				 }

		  }
		     window(1,1,80,25);
		     puttext(23,14,56,20,buf1);
		  }
	      }
i=-1;
gotoxy(cx,cy);
   }
puttext(1,1,80,1,buf);
textattr(0x07);
}

//********************* 4- HEX , Enter****************
unsigned int vvod4Hex(unsigned int vvod)        // HEX 
     {
     char string[5];      //ᨢ  ப
     char letter;         // ᨬ  ⮡ࠦ
     char i=0;
     sprintf(string,"%04X",vvod);   //ॢ  ப ६ vvod
     _setcursortype(_SOLIDCURSOR);
     printf("%s\b\b\b\b",string);
     do {
     letter = getch();
     if (!letter)
	letter = getch();
     if ((toascii(letter)==letter) && isxdigit(letter) && (i<4))
          { letter = toupper(letter);
            printf("%c",letter);              // HEX ᨬ
            string[i]=letter;
            i++;
          }
	  else
	  {
	  switch(letter)
	    {
	    case 75: {  if (i > 0)             //LEFT
			 {  printf("\b"); i--; }
			break;
		     }
	    case 77: {  if (i<3)               //RIGHT
			 {  gotoxy((wherex()+1),wherey()); i++; }
			break;
		     }
	    case 13: break;
	    default: printf("\a");
	    }
	  }
	 } while (letter!=13);                 //ENTER
       sscanf (string, "%x", &vvod);           // 祭
       _setcursortype(_NOCURSOR);
       return(vvod);
     }
//********************* 室  ணࠬ *************
void vihod (void)  {
	    byte buf[200];
		gettext(30,9,53,12,buf);
		textattr(0x30);
		window(30,9,53,12);
		clrscr();
		cprintf("\n   室  ணࠬ\?           (Enter)");
		window(1,1,80,25);
		if (getch()==13)
		     { textattr(0x07);
		      clrscr();
		      _setcursortype(_NORMALCURSOR);
		      exit(0); }
		puttext(30,9,53,12,buf);
		   }

//************* 祭  䠩  ⥬  ⥪. .******
byte pathName(void)
{
    byte i;                            //᫥  ᨬ
    byte drive[MAXDRIVE]="";
    byte dir[MAXDIR]="";
    byte file[MAXFILE]="";
    byte ext[MAXEXT]="";
    byte string[13]="";                   // ᨢ  ப
    byte *ptr;
	getcwd(filename,MAXPATH);              /* get the current working directory */
	if (strlen(filename)>3)         //᫨  ୥ ४,  \
	    strcat(filename,"\\");                 /* append on a trailing \ character */
	printf("%s",filename);
	i=vvodFname(&string[0]);
	fnsplit(filename,drive,dir,file,ext); /* split the string to separate elems */
	ptr = strchr(string,'.');       //⥫
      if (ptr)
    {   strncat(file, string, (ptr - string)); // 
	strncpy(ext, ptr, 4);                  //   ७
    }
      else {  strncpy(file, string, 8);	   //     ७
	      strcpy(ext,".hex");
	   }
	fnmerge(filename,drive,dir,file,ext);   /* merge everything into one string */
	return (i);
 }

//***********   ⮡ࠦ  䠩***************
 byte vvodFname(byte *string)        // 
     {
     byte letter;         // ᨬ  ⮡ࠦ
     char i=0;
     _setcursortype(_NORMALCURSOR);
     do {
     letter = getch();
     if (!iscntrl(letter) && (letter!=75) && (letter!=77) && (letter!=32) && (i<11))
	  { printf("%c",letter);              // ᨬ
	   string[i]=letter;
	    i++;
	  }
	  switch(letter)
	    {
            case 75: {  if (i > 0)             //LEFT
                         {  printf("\b"); i--; }
                        break;
                     }
	    case 77: {  if (i<10)               //RIGHT
			 {  gotoxy((wherex()+1),wherey()); i++; }
			break;
		     }
	    case  8: {  if (i > 0)             // BC
			 {  printf("\b \b"); i--; string[i]=0; }
		     }  break;
	    }
	 } while ((letter!=13) && (letter!=27));  //ENTER  ESC
       _setcursortype(_NOCURSOR);
       return(letter);
   }

//**************  ப  ⨯ PIC *************
void pechatPic(void)
{
byte marcaPic [7][6]={"C83","C84","F83","F84","CE623","CE624","CE625"};
     window(1,24,80,24);
     textbackground(1);
     clrscr();
     textattr(0x31);
     gotoxy(1,24);
     cprintf("  PIC16%s (%XH)   %s ",marcaPic[tippic],progMemSize[tippic],filename);
     window(1,1,80,25);
   }

// *************⥭ HEX 䠩***********
int getachar()
{
	int c;

	do
		c = fgetc(inputfile);
	while (c == '\r');		/* strip LF out of MSDOS files */

	return c;
}

unsigned char getbyte()
{
	unsigned char byte;
	unsigned int  data;

	fscanf(inputfile,"%02x",&data);

	byte = data & 0xff;
	checksum += byte;	/* all the bytes are used in the checksum */
				/* so here is the best place to update it */
	return byte;
}

char readihex(void)
{
	unsigned int address;
	int linetype = 0;
	int wordsthisline;
	int i;
	int lineCount = 1;
	int csby;
	unsigned char hi, lo;

	if ((inputfile = fopen(filename,"r")) == NULL)
	{
		printf("\n\a  Could not open input file %s",filename);
		return(1);     //訡
	}
      
	while (1)
	{
		if (getachar() != ':' )
		{
			printf("\a  Need a colon as first character in each line\n");
			printf("  Colon missing in line %d", lineCount);
			return(1);   //訡
		}

		checksum = 0;

		wordsthisline = getbyte()/2;
		hi = getbyte();
		lo = getbyte();
		address = (hi<<8 | lo) / 2;

		/* wierdness of INHX16! address different */
		/* endian-ness and 2x too big */

		linetype = getbyte();	/* 0 for data, 1 for end  */

		if(linetype == 1)	/* lets get out of here hit the end */
			break;

		for(i=0; i<wordsthisline; i++)
		{
			if (address >= BSIZE)
			{
				printf("\a  Address out of range\n");
				printf("  Got %04xH maximum is %04xH at line %d",address,BSIZE, lineCount);
				return(1);       //訡
			}

			lo = getbyte();
			hi = getbyte();
			progbuf[address] = (unsigned short)((hi<<8) | lo);
			++address;
		}

		csby = getbyte();	/* get the checksum byte */
					/* this should make the checksum zero */
					/* due to side effect of getbyte */

		if (checksum)
		{
			printf("\a  Checksum error in input file.\n");
			printf("  Got %02xH want %02xH at line %d",csby, (0-checksum) & 0xff, lineCount);
			return(1);      //訡
		}

		(void)getachar();		/* lose <return> */

		lineCount++;
	}

	fclose(inputfile);
	return(0);                   //ᯥ譮 ⥭ 䠩
}
//********************  HEX 䠩*****************
void printhex(int val)
{
	int chop;

	chop = val & 0xff;
	fprintf(outputfile,"%02X",chop);
	checksum += chop;
}

void writeihex(unsigned int current, unsigned int top)
{
	int numinthisline;
	int i;
	unsigned int addr;
	unsigned int numberofwords;

	numberofwords = top + 1;

	while(current < numberofwords)
	{
		checksum = 0;
		numinthisline = numberofwords - current;

		if (numinthisline > 8)
			numinthisline = 8;

		fputc(':',outputfile);

		printhex(numinthisline*2);

		addr = current*2;

		printhex(addr>>8);
		printhex(addr);

		printhex(0);

		for(i=0;i<numinthisline;i++)
		{
			printhex(progbuf[current+i]);
			printhex(progbuf[current+i]>>8);
		}

		printhex(0-checksum);
		fputc('\n', outputfile);

		current += numinthisline;
	}

}

char writePIC(void)
     {  if (access(filename,0)==0)
	{    printf("\n   %s . ९\? (Enter)",filename);
	     if (getch()!=13)
	     {   ungetch(13);
		return(1);    }
	}
     	if ((outputfile=fopen(filename,"w")) == NULL)
	{
		printf("\n\r\a  Could not open output file %s",filename);
		clreol();
		return(1);
	}
	writeihex(0x0000,(progMemSize[tippic]-1));  //Program memory
	writeihex(0x2000,0x2003);                   //ID
	writeihex(0x2007,0x2007);                   //Config
	if (tippic<EPROM)
	    writeihex(0x2100,0x213f);               //Data
	fprintf(outputfile,":00000001FF\n");
	fclose(outputfile);
	return(0);                //ᯥ譠 
      }
//**  SERIAL PROGRAMMING ROUTINE FOR THE PIC16C..., MICROCONTROLLER  **
//*********************************************************************

// cmd:	LOAD_CONFIG   -> part configuration bits
//	LOAD_DATA     -> program data, write
//	READ_DATA     -> program data, read
//      INC_ADDR      -> increment to the next address (routine does not auto increment)
//	BEGIN_PROG    -> program a previously loaded program code or data
//      END_PROG      ->  ணࠬ஢ (⮫쪮  PIC16c6...)
//	LOAD_DATA_DM  -> load EEPROM data regesters (BEGIN_PROG must folow)
//	READ_DATA_DM  -> read EEPROM data
//
// data: 1) 14 bits of program data or
//       2)  8 bits of EEPROM data (least significant 8 bits of int)
//
// Additional programmer commands (not part of PIC16C... programming codes)
// cmd:	RESET         -> ॢ  ﭨ ""
//      PROGRAM_MODE  -> initializes PIC16C... for programming
//      RUN           ->  PIC
//
// function returns: 1) 14 or 8 bits read back data for read commands
//		     2) zero                        for write data commands
//		     3) PIC_PROG_EROR = -1 for programming function errors
//		     4) PROGMR_ERROR  = -2 for programmer function errors
// parallel port bits
//	d0: data output to part to be programmed
//	d1: programming clock
//	d2: data dirrection, 0= enabel tri state buf -> send data to part
//	d3: Vpp control 1= turn on Vpp
//	d4: ~MCLR =0, 1 = reset device with MCLR line
//	d5: clock line tri state control, 0 = enable clock line

int ser_pic16(int cmd, int data)     // custom interface for pic 16c/f...
  {
  int i, s_cmd;

  del100();                             //প 100
  if(cmd <=MAX_PIC_CMD)                 // all programming modes
    {
    biosprint(0,8,PTR); 		// set bits 001000, output mode, clock & data low
    s_cmd = cmd;                        // retain command "cmd"
    for (i=0;i<6;i++)              	// output 6 bits of command
      {
      biosprint(0,(s_cmd&0x1) +2+8,PTR);// set bits 001010, clock hi
      biosprint(0,(s_cmd&0x1)   +8,PTR);// set bits 001000, clock low
      s_cmd >>=1;
      }

    if((cmd ==LOAD_DATA)||(cmd ==LOAD_DATA_DM)||(cmd ==LOAD_CONFIG)) // output 14 bits of data
      {
      for (i=200;i;i--) ; 		// delay between command & data
      biosprint(0,2+8,PTR);    		// set bits 001010, clock hi; leading bit
      biosprint(0,  8,PTR);    		// set bits 001000, clock low

      for (i=0;i<14;i++)        	// 14 data bits, lsb first
	{
	biosprint(0,(data&0x1) +2+8,PTR);// set bits 001010,  clock hi
	biosprint(0,(data&0x1)   +8,PTR);// set bits 001000,  clock low
	data >>=1;
	}
      biosprint(0,2+8,PTR);    		// set bits 001010, clock hi; trailing bit
      biosprint(0,  8,PTR);    		// set bits 001000, clock low
      return 0;
      }

    else if((cmd ==READ_DATA)||(cmd ==READ_DATA_DM)) //read 14 bits from part, lsb first
      {
      biosprint(0,  4+8,PTR);    	// set bits 001100, clock low, tri state data buffer
      for (i=200;i;i--) ; 		// delay between command & data
      biosprint(0,2+4+8,PTR);    	// set bits 001110, clock hi, leading bit
      biosprint(0,  4+8,PTR);    	// set bits 001100, clock low

      data =0;
      for (i=0;i<14;i++)             	// input 14 bits of data, lsb first
	{
	data >>=1;                      // shift data for next input bit
	biosprint(0,2+4+8,PTR); 	// set bits 001110,  clock hi
	biosprint(0,  4+8,PTR); 	// set bits 001100,  clock low
	if(!(biosprint(2,0,0)&0x40)) data += 0x2000;//use printer acknowledge line for input, data lsb first
	}
      biosprint(0,2+4+8,PTR);    	// set bits 001110, clock hi, trailing bit
      biosprint(0,  4+8,PTR);    	// set bits 001100, clock low
      return data;
      }

    else return 0;                      // ⮫쪮   DATA          // programmer error

    }

  else if(cmd ==PROGRAM_MODE)           // enter program mode
    {
    biosprint(0,32+16+4,PTR);    	// set bits 110100, Vpp off, MCLR = low (reset PIC)
    delay(10);              		// 10 ms, allow programming voltage to stabelize
    biosprint(0,16,PTR);                // 010000, RB6=0, RB7=0
    del100();
    biosprint(0,8,PTR);     		// set bits 001000, Vpp on , MCLR = 13.5 volts, clock & data connected
    delay(10);              		// 10 ms, allow programming voltage to stablize

    return 0;
    }

  else if(cmd ==RUN)          		//  PIC
    {
    biosprint(0,32+16+4,PTR);  		// set bits 110100, MCLR = low (reset),
    delay(10);
    biosprint(0,32   +4,PTR); 		// set bits 100100, MCLR = high
    return 0;
    }

  else if(cmd == RESET)                 // reset device
    {
  i = biosprint(0,32+16+4,PTR); 	 // set bits 110100, MCLR = low (reset PIC), programmer not conected
    delay(10);                           // 10ms delay
    return i;                            //ﭨ ணࠬ
    }

  else return PROGMR_ERROR;             // command error
  }

//*************************⥭ PROGMEM  ****************
void rdPrg(unsigned int Addr, unsigned int Addrmax)
{  unsigned int i;
   for (i = Addr; i < Addrmax; i++)
     { progbuf[i] = (ser_pic16(READ_DATA,0) & 0x3fff);
       ser_pic16(INC_ADDR,0);
     }
}

//*************************⥭ ID, CONFIG  ***********
void rdId(void)
{
unsigned int Addr;
   ser_pic16(LOAD_CONFIG,0x3fff);
   for (Addr=0x2000; Addr < 0x2004; Addr++)
     { progbuf[Addr] = (ser_pic16(READ_DATA,0) & 0x3fff);
       ser_pic16(INC_ADDR,0);
     }
   ser_pic16(INC_ADDR,0);
   ser_pic16(INC_ADDR,0);
   ser_pic16(INC_ADDR,0);
   progbuf[0x2007] = (ser_pic16(READ_DATA,0) & 0x3fff);
}

//*************************⥭ DATAMEM  **************
void rdData(unsigned int Addr,unsigned int Addrmax)
{  unsigned int i;
   for (i = Addr; i < Addrmax; i++)
     { progbuf[i] = ser_pic16(READ_DATA_DM,0) & 0x00ff;
       ser_pic16(INC_ADDR,0);
     }
}

//******************ࠢ  ஬ PROGMEM***************
unsigned int verPrg(unsigned int Addr, unsigned int Addrmax)
{   unsigned int i;
    unsigned int j=0;            //稪 訡
    for (i=Addr; i<Addrmax; i++)
      { if ((progbuf[i] & 0x3fff) != (ser_pic16(READ_DATA,0) & 0x3fff))
	      j++;
	ser_pic16(INC_ADDR,0);
      }
    return j;
}

//******************ࠢ  ஬ ID, CONFIG*************
unsigned int verId(void)
{   unsigned int i;
    unsigned int j=0;
    ser_pic16(LOAD_CONFIG,0x3fff);
    for (i=0x2000; i<0x2004; i++)
      { if ((progbuf[i] & 0x3fff) != (ser_pic16(READ_DATA,0) & 0x3fff))
	      j++;
	ser_pic16(INC_ADDR,0);
      }
	ser_pic16(INC_ADDR,0);
	ser_pic16(INC_ADDR,0);
	ser_pic16(INC_ADDR,0);
	if ((progbuf[0x2007] & 0x3fff) != (ser_pic16(READ_DATA,0) & 0x3fff))
	      j++;
	return j;
}

//***********************ࠢ  ஬ DATA************
unsigned int verData(unsigned int Addr,unsigned int Addrmax)
{  unsigned int i;
   unsigned int j=0;
   for (i = Addr; i < Addrmax; i++)
      { if ((progbuf[i] & 0x00ff) != (ser_pic16(READ_DATA_DM,0) & 0x00ff))
	      j++;
	ser_pic16(INC_ADDR,0);
      }
   return j;
}
//******************஢ઠ   PROGMEM***************
unsigned int blankPrg(unsigned int Addr, unsigned int Addrmax)
{   unsigned int i;
    unsigned int j=0;            //稪 訡
    for (i=Addr; i<Addrmax; i++)
      { if ((ser_pic16(READ_DATA,0) & 0x3fff) != 0x3fff)
	      j++;
	ser_pic16(INC_ADDR,0);
      }
    return j;
}

//******************஢ઠ   ID, CONFIG*************
unsigned int blankId(void)
{   unsigned int i;
    unsigned int j=0;
    ser_pic16(LOAD_CONFIG,0x3fff);
    for (i=0x2000; i<0x2004; i++)
      { if ((ser_pic16(READ_DATA,0) & 0x3fff) != 0x3fff)
	      j++;
	ser_pic16(INC_ADDR,0);
      }
	ser_pic16(INC_ADDR,0);
	ser_pic16(INC_ADDR,0);
	ser_pic16(INC_ADDR,0);
	if ((ser_pic16(READ_DATA,0) & 0x3fff) != 0x3fff)
	      j++;
	return j;
}

//***********************஢ઠ   DATA************
unsigned int blankData(unsigned int Addr,unsigned int Addrmax)
{  unsigned int i;
   unsigned int j=0;
   for (i = Addr; i < Addrmax; i++)
      { if ((ser_pic16(READ_DATA_DM,0) & 0x00ff) != 0x00ff)
	      j++;
	ser_pic16(INC_ADDR,0);
      }
   return j;
}

//*******************ࠢ PIC  ஬*****************
unsigned int verPic(void)
{  unsigned int errPrg, errId, errData=0;
   cprintf("     ࠢ PIC c ஬\n\r  Program memory:  ");
   errPrg = verPrg(0,progMemSize[tippic]);
   cprintf("%4d 訡\n\r  ID, Config:      ",errPrg);
   errId = verId();
   cprintf("%4d 訡\n\r",errId);
   if (tippic < EPROM)                     //DATA
     { ser_pic16(PROGRAM_MODE,0);
       cprintf("  Data memory:     ");
       errData = verData(0x2100,0x2140);
       cprintf("%4d 訡\n\r",errData);
     }
   ser_pic16(RESET,0);
   errPrg = (errPrg + errId + errData);
   if (errPrg)
      cprintf("  ᮢ !\a\n\r");
   else cprintf("   !\n\r");
   return errPrg;
}

//*******************஢ઠ PIC  ********************
unsigned int blankPic(void)
{  unsigned int errPrg, errId, errData=0;
   cprintf("     ஢ઠ PIC  \n\r  Program memory:  ");
   errPrg = blankPrg(0,progMemSize[tippic]);
   cprintf("%4d 訡\n\r  ID, Config:      ",errPrg);
   errId = blankId();
   cprintf("%4d 訡\n\r",errId);
   if (tippic < EPROM)                     //DATA
     { ser_pic16(PROGRAM_MODE,0);
       cprintf("  Data memory:     ");
       errData = blankData(0x2100,0x2140);
       cprintf("%4d 訡\n\r",errData);
     }
   ser_pic16(RESET,0);
   errPrg = (errPrg + errId + errData);
   if (errPrg)
      cprintf("    !\a\n\r");
   else cprintf("   \n\r");
   return errPrg;
}

//****************** DATA MEMORY 16C84*****************

unsigned int wrData(unsigned int Addr,unsigned int Addrmax)
{  unsigned int i;
   unsigned int data;
   cprintf("         Data Memory\n\r");
   for (i = Addr; i < Addrmax; i++)
      { data = (progbuf[i] & 0x00ff);
	if (data != (ser_pic16(READ_DATA_DM,0) & 0x00ff))
	  {  ser_pic16(LOAD_DATA_DM,data);
	     ser_pic16(BEGIN_PROG,0);
	     delay(13);
	     if (data != (ser_pic16(READ_DATA_DM,0) & 0x00ff))
	       return(i-Addr+1);                // 訡  +1
	  }
	     ser_pic16(INC_ADDR,0);
	     cprintf(" %04X\r",(i-Addr));
      }
   ser_pic16(PROGRAM_MODE,0);
   for (i = Addr; i < Addrmax; i++)
      { if ((progbuf[i] & 0x00ff) != (ser_pic16(READ_DATA_DM,0) & 0x00ff))
	  return (i-Addr+1);		    // 訡 ஢ન +1
	ser_pic16(INC_ADDR,0);
      }
   return 0;
}

//****************** PROGRAM MEMORY ***********************

unsigned int wrPrg(unsigned int Addr,unsigned int Addrmax)
{  unsigned int data, i;
   byte j;
   cprintf("       Program Memory\n\r");
   for (i = Addr; i < Addrmax; i++)
      { data = (progbuf[i] & 0x3fff);
	if (data != (ser_pic16(READ_DATA,0) & 0x3fff))
	  { if (tippic<EPROM)
	    {  ser_pic16(LOAD_DATA,data);
	       ser_pic16(BEGIN_PROG,0);
	       delay(13);
	       if (data != (ser_pic16(READ_DATA,0) & 0x3fff))
		 return(i+1);                // 訡  +1
	    }
	    else
	    { j=0;
	      do { wrCEprom(data); j++;
		 } while ((data != (ser_pic16(READ_DATA,0) & 0x3fff)) && (j<25));
	      if (j>=25)
		return(i+1);           //訡 
	      for ((j=j*3); j>0; j--)
		wrCEprom(data);        //९塞
	    }
	  }
	ser_pic16(INC_ADDR,0);
	cprintf(" %04X\r",i);
      }
   clrscr();
   cprintf("  ஢ઠ  Program Memory\n\r");
   ser_pic16(PROGRAM_MODE,0);         //஢ઠ
   for (i = Addr; i < Addrmax; i++)
      { if ((progbuf[i] & 0x3fff) != (ser_pic16(READ_DATA,0) & 0x3fff))
	  return (i+1);		    // 訡 ஢ન +1
	ser_pic16(INC_ADDR,0);
      }
   return 0;
}
//******************  EPROM*******************************
void wrCEprom(unsigned int data)
    { ser_pic16(LOAD_DATA,data);
      ser_pic16(BEGIN_PROG,0);
      ser_pic16(END_PROG,0);
    }
//***************** ID, CONFIG*********************************
unsigned int wrID()
{  unsigned int data, i;
   byte j;
   cprintf("         ID, Config\n\r");
   ser_pic16(LOAD_CONFIG,0x3fff);                    // ID
   for (i = 0x2000; i < 0x2004; i++)
      { data = (progbuf[i] & 0x3fff);
	if (data != (ser_pic16(READ_DATA,0) & 0x3fff))
	  { if (tippic<EPROM)
	    {  ser_pic16(LOAD_DATA,data);
	       ser_pic16(BEGIN_PROG,0);
	       delay(13);
	       if (data != (ser_pic16(READ_DATA,0) & 0x3fff))
		 return(i+1);                // 訡  +1
	    }
	    else
	    { j=0;

	      do { wrCEprom(data); j++;
		 } while ((data != (ser_pic16(READ_DATA,0) & 0x3fff)) && (j<25));
	      if (j>=25)
		return(i+1);      //訡 
	      for ((j=j*3); j>0; j--)
		wrCEprom(data);        //९塞
	    }
	  }
	ser_pic16(INC_ADDR,0);
      }
   ser_pic16(PROGRAM_MODE,0);         //஢ઠ
   ser_pic16(LOAD_CONFIG,0x3fff);
   for (i = 0x2000; i < 0x2004; i++)
      { if ((progbuf[i] & 0x3fff) != (ser_pic16(READ_DATA,0) & 0x3fff))
	  return (i+1);		    // 訡 ஢ન +1
	ser_pic16(INC_ADDR,0);
      }
   ser_pic16(INC_ADDR,0);
   ser_pic16(INC_ADDR,0);
   ser_pic16(INC_ADDR,0);
   data = (progbuf[0x2007] & 0x3fff);             // CONFIG
   if (((tippic<EPROM) && ((data & 0x3ff0) != 0x3ff0)) || ((tippic>=EPROM) && ((data & 0x3f30) != 0x3f30)))
     {	cprintf("   ⠭? (Y/N)");
	j = mygetch();
	if ((j!=89) && (j!=121))
	  {  cprintf("  N\n\r");
	     if (tippic<EPROM)
		data = (data | 0x3ff0);     //᪨஢  
	     else
		data = (data | 0x3f30);
	  }
	else  cprintf("  Y\n\r");
     }
  if (data != (ser_pic16(READ_DATA,0) & 0x3fff))
    { if (tippic<EPROM)
      {  ser_pic16(LOAD_DATA,data);
	 ser_pic16(BEGIN_PROG,0);
	 delay(13);
      }
      else
      { for (j=0; j<80; j++)
	   wrCEprom(data);
      }
    }
	if (data != (ser_pic16(READ_DATA,0) & 0x3fff))
	   return(0x2007+1);                // 訡  +1

  return 0;
}

//***************** ᮮ.  訡  PIC*****************
void errwr (unsigned int err)
      {  cprintf("  訡    %04X\a\n\r",(err-1));
	 cprintf("        ");
	 mygetch();
      }
//*******************뢮 Help**************************************
void helpPrg()
{
byte buf[2300];

gettext(10,4,70,21,buf);
window(10,4,70,21);
textattr(0x30);
clrscr();
cputs("\n       ணࠬ PIC ஫஢  2 (24.05.99)\n\n\r");
cputs("     ணࠬ, ᮡ࠭   奬  AN589  (DS00589A by\n\r"
      "  Microchip) 砥   LPT1. 室 䠩 \n\r"
      "    ଠ Intel HEX8M. 饭   :\n\r"
      "  Program Memory -   0000H,\n\r"
      "  ID location ............. 2000H - 2003H,\n\r"
      "  Configuration Word ...... 2007H,\n\r"
      "  Data Memory ............. 2100H - 213FH.\n\r"
      "          ࠭  2  (lsb first), \n\r"
      "  Data Memory 騬   ⮫쪮 訩 . \n\r"
      "  ଠ ন MPASM ( DW).\n\r"
      "     HEX 䠩    室   ४ਨ,  ன\n\r"
      "  ᪠   ணࠬ. ᪠     \n\r"
      "   ப.\n\n\r"
      "                       ");
mygetch();
window(1,1,80,25);
puttext(10,4,70,21,buf);
}
//*********************************************************
